<header class="main-header header-style-two">
    <div class="header-lower">
        <div class="custom-container">
            <div class="inner-container d-flex align-items-center justify-content-between">

                <div class="left-column">
                    <div class="logo-box">
                        <div class="logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('logo.svg')); ?>" alt="logo"></a></div>
                    </div>
                </div>
                <div class="middle-column d-flex align-items-center">
                    <div class="nav-outer">
                        <div class="dashboardIconDiv float-end d-block d-lg-none pe-1">
                            <a href="<?php echo e(url('/')); ?>/user/dashboard"><i
                                    class="fa-regular fa-grid dashboardIcon white-icon"></i>
                                <span></span></a>
                        </div>
                        <div class="mobile-nav-toggler"><img src="<?php echo e(asset('frontend/images/icons/icon-bar.png')); ?>"
                                alt="icon" class="white-icon"></div>
                        <nav class="main-menu navbar-expand-md navbar-light">
                            <div class="collapse navbar-collapse show clearfix" id="navbarSupportedContent">
                                <ul class="navigation">
                                    <li class="nav-item <?php echo e(activeNav('home')); ?>"><a class="nav-link " href="<?php echo e(url('/')); ?>"><?php echo app('translator')->get('app.home'); ?></a>
                                    </li>
                                    <li class="nav-item <?php echo e(activeNav('about')); ?>"><a class="nav-link " href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('app.about-title'); ?></a>
                                    </li>
                                    <li class="nav-item <?php echo e(activeNav('destination')); ?>"><a class="nav-link "
                                            href="<?php echo e(route('destination')); ?>"><?php echo app('translator')->get('app.destination'); ?></a>
                                    </li>
                                    <li class="nav-item <?php echo e(activeNav('package')); ?>"><a class="nav-link " href="<?php echo e(route('package')); ?>"><?php echo app('translator')->get('app.package'); ?></a>
                                    </li>
                                    <li class="nav-item <?php echo e(activeNav('faq')); ?>"><a class="nav-link " href="<?php echo e(route('faq')); ?>"><?php echo app('translator')->get('app.faq'); ?></a></li>
                                    <li class="nav-item <?php echo e(activeNav('contact')); ?>"><a class="nav-link " href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('app.contact'); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </nav>
                    </div>
                </div>
                <div class="right-column d-flex align-items-center">
                    <div class="header-right-inner">
                        <div class="language">
                            <div class="language-icon">
                                <i class="fa-thin fa-globe"></i>
                                <ul>
                                    <li>
                                        <span>
                                            <a href="<?php echo e(route('set-locale', 'en')); ?>" class="language <?php echo e(app()->getLocale()==='en'?'lang_active':''); ?>">
                                                <img class="languageIcon"
                                                    src="<?php echo e(asset('flags/us.svg')); ?>" />
                                                <span><?php echo app('translator')->get("English"); ?></span>
                                            </a>
                                        </span>
                                    </li>
                                    <li>
                                        <span>
                                            <a href="<?php echo e(route('set-locale', 'bn')); ?>" class="language <?php echo e(app()->getLocale()==='bn'?'lang_active':''); ?>">
                                                <img class="languageIcon"
                                                    src="<?php echo e(asset('flags/bd.svg')); ?>" />
                                                <span><?php echo app('translator')->get('Bangla'); ?></span>
                                            </a>
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="sign-up">
                            <div class="sign-up-border"></div>
                            <?php if(auth()->guard()->guest()): ?>
                            <div class="button-2">
                                <a href="<?php echo e(url('/')); ?>/register" class="btn-2"><?php echo app('translator')->get('auth.signup'); ?><span></span></a>
                            </div>
                            <div class="button-1">
                                <a href="<?php echo e(url('/')); ?>/login" class="btn-1"><?php echo app('translator')->get('auth.singin'); ?><span></span></a>
                            </div>
                            <?php else: ?>
                            <div class="button-1">
                                <a href="<?php echo e(url('/')); ?>/login" class="btn-1"><?php echo app('translator')->get('app.dashboard'); ?><span></span></a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Header Lower -->


    <!-- sticky header -->
    <div class="sticky-header">
        <div class="header-upper">
            <div class="container">
                <div class="inner-container d-flex align-items-center justify-content-between">
                    <div class="left-column d-flex align-items-center">
                        <div class="logo-box">
                            <div class="logo">
                                <a href="<?php echo e(url('/')); ?>">
                                    <img src="<?php echo e(asset('logo.svg')); ?>" alt="logo">
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="nav-outer">
                        <div class="dashboardIconDiv float-end d-block d-lg-none pe-1">
                            <a href="<?php echo e(url('/')); ?>/user/dashboard"><i
                                    class="fa-regular fa-grid dashboardIcon white-icon"></i>
                                <span></span></a>
                        </div>
                        <div class="mobile-nav-toggler"><img class="white-icon"
                                src="<?php echo e(asset('frontend/images/icons/icon-bar.png')); ?>" alt="icon"></div>
                        <nav class="main-menu navbar-expand-md navbar-light">
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- sticky header -->


    <!-- mobile menu -->
    <div class="mobile-menu">
        <div class="menu-backdrop"></div>
        <div class="close-btn"><span class="fal fa-times"></span></div>
        <nav class="menu-box">
            <div class="nav-logo"><a href="<?php echo e(url('/')); ?>"><img src="<?php echo e(asset('logo.svg')); ?>" alt="logo"></a>
            </div>
            <div class="menu-outer">
                <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
            </div>
            <!--Social Links-->

            <div class="social-links">
                <ul class="clearfix">
                    <li><a href=""><span class="fab fa-twitter"></span></a>
                    </li>
                    <li><a href=""><span class="fab fa-facebook-square"></span></a>
                    </li>
                    <li><a href=""><span class="fab fa-linkedin-in"></span></a>
                    </li>
                    <li><a href=""><span class="fab fa-instagram"></span></a>
                    </li>
                </ul>
            </div>
        </nav>
    </div>

    <div class="nav-overlay">
        <div class="cursor"></div>
        <div class="cursor-follower"></div>
    </div>
</header>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/components/frontend/global/navigation.blade.php ENDPATH**/ ?>